// Craig S. Kaplan
// A demonstration of how geometric context affects everything
// drawn in a sketch, including ControlP5 widgets!  So be careful,
// and maybe surround everything with pushMatrix()/popMatrix().

import controlP5.*;

ControlP5 ui;
PImage img;
PShape shp;

void setup()
{
  size( 500, 500 );
  ui = new ControlP5( this );
  ui.addButton( "Hello" ).setPosition( 10, 10 );
  
  img = loadImage( "bowie_150.jpg" );
  shp = loadShape( "snowflake10.svg" );
}
 
void draw()
{
  background( 0 );

  // Uncomment this to see the sketch rotate
  // about its centre.
  /*
  translate( 250, 250 );
  rotate( radians( frameCount * 0.5 ) );
  translate( -250, -250 );
  */

  fill( 255 );
  ellipse( 125, 125, 100, 70 );
  textAlign( CENTER );
  fill( 0 );
  text( "TEST", 375, 125 );
  image( img, 0, 250, 250, 250 );
  shape( shp, 250, 250, 250, 250 );
}